<?php
/*--------------------------------------------------------------
   Repository.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Data;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Timespan;

class Repository
{
    /**
     * @var Reader
     */
    private $reader;
    
    /**
     * @var Mapper
     */
    private $mapper;
    
    
    /**
     * Constructor.
     */
    public function __construct(Reader $reader, Mapper $mapper)
    {
        $this->reader = $reader;
        $this->mapper = $mapper;
    }
    
    
    /**
     * Return orders for provided time span.
     */
    public function getOrdersByTimespan(Timespan $timespan): Serial
    {
        return $this->mapper->mapOrders($this->reader->ordersByTimespan($timespan));
    }
    
    
    /**
     * Return sales for provided time span.
     */
    public function getSalesByTimespan(Timespan $timespan): Serial
    {
        return $this->mapper->mapSales($this->reader->salesByTimespan($timespan));
    }
    
    
    /**
     * Return visitors for provided time span.
     */
    public function getVisitorsByTimespan(Timespan $timespan): Serial
    {
        return $this->mapper->mapVisitors($this->reader->visitorsByTimespan($timespan));
    }
    
    
    /**
     * Return conversion rates for provided time span.
     */
    public function getConversionRatesByTimespan(Timespan $timespan): Serial
    {
        return $this->mapper->mapConversionRates($this->reader->conversionRatesByTimespan($timespan));
    }
}